/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.internal.build.properties;

import com.aptana.css.core.internal.build.properties.CustomCSSProperty;
import com.aptana.css.core.internal.build.properties.ICSSValueTypeConverter;
import com.aptana.css.core.internal.build.properties.ICSSValueValidator;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;

public class PlugableCSSProperty
extends CustomCSSProperty {
    private final CssValue value;

    public PlugableCSSProperty(String propertyName) {
        super(propertyName);
        this.value = null;
    }

    public PlugableCSSProperty(String propertyName, Class[] types, ICSSValueTypeConverter[] converters, ICSSValueValidator[] validators, ApplContext context, CssExpression expression, boolean check) throws InvalidParamException {
        super(propertyName);
        if (check && expression.getCount() != 1) {
            throw new InvalidParamException("unrecognize", context);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        Class[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            if (type.isInstance(val)) {
                int n3;
                int n4;
                Object[] objectArray;
                expression.next();
                if (converters != null && converters.length != 0) {
                    objectArray = converters;
                    n4 = converters.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object converter = objectArray[n3];
                        CssValue convertedValue = converter.convert(val);
                        if (convertedValue != null) {
                            val = convertedValue;
                            break;
                        }
                        ++n3;
                    }
                }
                if (validators != null && validators.length != 0) {
                    objectArray = validators;
                    n4 = validators.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object validator = objectArray[n3];
                        if (validator.canValidate(val) && !validator.isValid(val)) {
                            throw new InvalidParamException("value", (Object)val.toString(), (Object)this.getPropertyNameNoMinus(), context);
                        }
                        ++n3;
                    }
                }
                this.value = val;
                return;
            }
            ++n2;
        }
        throw new InvalidParamException("value", (Object)val.toString(), (Object)this.getPropertyNameNoMinus(), context);
    }

    public PlugableCSSProperty(String propertyName, Class[] types, ICSSValueTypeConverter[] converters, ICSSValueValidator[] validators, ApplContext context, CssExpression expression) throws InvalidParamException {
        this(propertyName, types, converters, validators, context, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public boolean isDefault() {
        return false;
    }
}

